/** An instance is a report on student records */
public class StudentReport {
   private Student[] student; // students are in
   private int num;           // student[0..num-1]
     
   private double av;    // average grade
   private int numAPlus; // no. students with grade >= 99
   
   /** Read in data and print the average grade, the
       number of A+s, and the students who got A+ */
   public static void main(String pars[]) {
      StudentReport r= new StudentReport();
      r.getData();
      r.calculate();
      r.printReport();      
   }
   
   /** Read in the data for the students */
   public void getData() {
      System.out.println("Enter the number of students");
      num= JLiveRead.readLineInt();
      student= new Student[num];
      for (int i= 0; i != num; i++) {
         student[i]= new Student();
         student[i].read();
      }
   }
      
   /** av= average of the grades of Student[0..num-1].
       numFailures=  number of A+'s in Student[0..num-1].
       Precondition: There is at least one student (num > 0) */
   public void calculate() {
      av= 0;
      numAPlus= 0;
      // inv: av is the sum of grades of student[0..i-1]
      //      numAPlus is no. A+'s in student[0..i-1]
      for (int i= 0; i != num; i++) {
         av= av+ student[i].getGrade();
         if (student[i].getGrade() >= 99)
            numAPlus++;
      }
      av= av/num;
   }
   
   /** Print the average grade, the number
       of A+s, and the students who got A+ */
   public void printReport() {
      System.out.println("Average: " + av +
                         ", number of A+'s: " + numAPlus);
      
      System.out.println("Students who received A+:");
      for (int i= 0; i != num; i++) {
         if (student[i].getGrade() >= 99)
            {System.out.println("  " + student[i]);}
      }
       
      System.out.println("\nOther students:");   
      for (int i= 0; i != num; i++) {
         if (student[i].getGrade() < 99)
            {System.out.println("  " + student[i]);}
      }
   }
}
